varying vec4 p_color;
varying vec2 p_textureCoord;

varying vec3 p_lightVec; 
varying vec3 p_halfVec;

uniform float p_ambient_factor;
uniform vec3 p_specularColor;
uniform float p_specularPower;
uniform vec3 p_ambientColor;

uniform sampler2D base_texture;
uniform sampler2D normal_texture;

void main()
{
    vec4 baseColor = texture2D(base_texture, p_textureCoord) * p_color;
    vec4 resultColor;
    resultColor.a = baseColor.a;
    
    vec3 normalVec = normalize(texture2D(normal_texture, p_textureCoord).xyz * 2.0 - 1.0);

    float diffuse_factor = max(dot(normalVec, p_lightVec), 0.0);
    vec3 specular_color = pow(max( dot(normalize(p_halfVec), normalVec), 0.0), p_specularPower)
                                    * p_specularColor;
    resultColor.xyz =  (p_ambient_factor + diffuse_factor) * baseColor.xyz + specular_color * baseColor.a
                        + p_ambientColor * baseColor.a;
    
    gl_FragColor = resultColor;
}
